package chess4j.pieces;

import chess4j.Color;
import chess4j.board.directions.East;
import chess4j.board.directions.North;
import chess4j.board.directions.NorthEast;
import chess4j.board.directions.NorthWest;
import chess4j.board.directions.South;
import chess4j.board.directions.SouthEast;
import chess4j.board.directions.SouthWest;
import chess4j.board.directions.West;

public class Queen extends SlidingPiece {

	public static final Queen WHITE_QUEEN = new Queen(Color.WHITE);
	public static final Queen BLACK_QUEEN = new Queen(Color.BLACK);
	
	private Queen(Color color) {
		super(color);
	}
	
	public String toString() {
		return isWhite()?"Q":"q";
	}
	
	@Override
	protected void addDirections() {
		_dirs.add(SouthEast.getInstance());
		_dirs.add(SouthWest.getInstance());
		_dirs.add(NorthEast.getInstance());
		_dirs.add(NorthWest.getInstance());
		_dirs.add(East.getInstance());
		_dirs.add(West.getInstance());
		_dirs.add(North.getInstance());
		_dirs.add(South.getInstance());
	}
}
